/*
 * @(#)Entity.java  1.1  2006-02-21
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.rer.model;

import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.event.*;
import java.util.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
/**
 * A simulated Entity.
 *
 * @author  Werner Randelshofer
 * @version 1.1 2006-02-21 Support for super-sub-type added.
 * <br>1.0 30. Januar 2004  Created.
 */
public class Entity extends AttributedElement<RERAttribute> {
    private String name;
    public final static int TYPE_FUNDAMENTAL = 0;
    public final static int TYPE_ATTRIBUTIVE = 1;
    public final static int TYPE_ASSOCIATIVE = 2;
    public final static int TYPE_SUPERTYPE = 3;
    public final static int TYPE_SUBTYPE = 4;
    public final static int TYPE_SUPERSUBTYPE = 5;
    
    private int type = TYPE_FUNDAMENTAL;
    
    /** Creates a new instance. */
    public Entity() {
        final ResourceBundleUtil labels = RelationalERModel.labels;
        name = labels.getString("entity");
    }
    
    public void setName(String newValue) {
        String oldValue = name;
            name = newValue;
            firePropertyChange("name", oldValue, newValue);
    }
    public String getName() {
        return name;
    }
    public void setType(int newValue) {
        int oldValue = type;
            type = newValue;
            firePropertyChange("type", oldValue, newValue);
    }
    public int getType() {
        return type;
    }
    
    protected RERAttribute createAttribute() {
        return new RERAttribute();
    }
    
    public Collection<Relationship> getRERRelationships() {
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        for (SimulatedRelationship c : getRelationships(RelationalERModel.RELATIONSHIP)) {
            relationships.add((Relationship) c);
        }
        return relationships;
    }
    public Collection<Entity> getRelatedEntities() {
        LinkedList<Entity> entities = new LinkedList<Entity>();
        for (SimulatedElement e : getRelatedElements(RelationalERModel.ENTITY)) {
            entities.add((Entity) e);
        }
        return entities;
    }
    /**
     * Returns all associations defined by this class and all its superclasses.
     */
    public Collection<Relationship> getAllRelations() {
        HashSet<Relationship> list = new HashSet(getRelationships(RelationalERModel.RELATIONSHIP));
        return list;
    }
    
    public int getSimulatedConcept() {
        return RelationalERModel.ENTITY;
    }
    
    public Entity clone() {
        Entity that = (Entity) super.clone();
        
        // We have to do a deep clone of the attributes, because
        // the identity of an attribute is used to determine to which
        // entity it belongs.
        that.attributes = new ArrayList<RERAttribute>();
        that.attributeHandler = new AttributeHandler(that);
        for (RERAttribute thisAttr : attributes) {
            that.addAttribute((RERAttribute) thisAttr.clone());
        }
        return that;
    }
    
    public void write(DOMOutput out) throws IOException {
        out.addAttribute("name", name);
        out.addAttribute("type", type);
        
        if (attributes.size() > 0) {
            out.openElement("Attributes");
            for (Iterator i=attributes.iterator(); i.hasNext(); ) {
                out.writeObject(i.next());
            }
            out.closeElement();
        }
    }
    public void read(DOMInput in) throws IOException {
        name = in.getAttribute("name", "Klasse");
        type = in.getAttribute("type", TYPE_FUNDAMENTAL);
        
        if (in.getElementCount("Attributes") > 0) {
            in.openElement("Attributes");
            for (int i=0; i < in.getElementCount(); i++) {
                addAttribute((RERAttribute) in.readObject(i));
            }
            in.closeElement();
        }
    }
    public RelationalERModel getERModel() {
        return (RelationalERModel) getSimulation();
    }
    public boolean isEquivalent(SimulatedObject o) {
        if (super.isEquivalent(o) && (o instanceof Entity)) {
            Entity that = (Entity) o;
            
            // FIXME - Add more criteria
            if (that.getType() == this.getType() &&
                    that.getAttributeCount() == this.getAttributeCount()) {
                return true;
            }
        }
        return false;
    }
}
